# P2P v5.0.8
**Release Date:** January 17, 2025  
**Tags:** SECURITY FIX, BALANCE VALIDATION, CURRENCY DISPLAY, UI IMPROVEMENTS

## Fixed
- Critical security bug allowing sell offers to be created without sufficient balance
- Trading volume display showing unwanted "/" character before amount
- Average completion time showing "N/A" instead of "0" for consistency
- Fiat currency display attempting to load images instead of showing currency codes
- Currency detection logic using length-based detection instead of proper ISO codes
- Seller email addresses exposed in P2P interfaces for security reasons
- Spacing issues in trade forms between min/max amounts and button text
- Payment methods could be deleted while still being used by active offers or trades

## Added
- Comprehensive balance validation for sell offers in backend API endpoint
- Automatic wallet balance fetching when currency is selected in offer creation
- Proper fiat currency detection using ISO 4217 currency codes
- Currency utility with 100+ global fiat currencies support
- Custom payment method admin control setting
- Available balance display in sell offer creation form
- Enhanced security validation preventing offers without sufficient funds
- Payment method deletion protection for active offers and ongoing trades

## Enhanced
- Currency display system with proper fiat vs crypto handling
- Decimal formatting with 2 decimals for fiat currencies and 8 for crypto
- P2P dashboard statistics display with consistent formatting
- Admin settings interface with custom payment method toggle
- Offer creation flow with real-time balance validation
- User privacy protection by removing email display from seller information
- Payment method selection respecting admin-configured restrictions

## Security Improvements
- Sell offers now require sufficient wallet balance before creation
- Backend validation prevents creation of offers exceeding available funds
- Frontend balance checking with real-time wallet balance fetching
- Proper error messages for insufficient balance scenarios
- Email privacy protection in P2P trading interfaces
- Enhanced validation for all P2P offer creation parameters
- Payment method integrity protection preventing deletion during active use

## Technical Improvements
- Added getWalletSafe import to P2P offer creation endpoint
- Implemented balance validation logic in backend API
- Enhanced currency utility with comprehensive fiat currency list
- Updated offer creation flow to fetch and validate user balances
- Improved error handling for wallet balance verification
- Added proper decimal formatting for different currency types
- Enhanced admin settings with custom payment method controls
- Added validation to prevent payment method deletion when in use by active offers or trades
- Comprehensive error messaging for payment method deletion restrictions 