# Version 5.4.4

**Release Date:** August 20, 2025  
**Tags:** BUG FIXES, INVESTMENT FIXES, AUTHENTICATION FIXES

## Fixed

### Authentication - reCAPTCHA v3
- **Token Validation**: Fixed reCAPTCHA token validation error in login endpoint
- **Schema Validation**: Resolved "Recaptcha Token is required" schema validation error
- **Environment Variables**: Fixed incorrect variable name and loading timing issues
- **Script Loading**: Improved reCAPTCHA v3 script loading with retry mechanism
- **Race Conditions**: Fixed issue where auth modal opens before reCAPTCHA script loads
- **Error Handling**: Enhanced error messages and consistent handling across all auth endpoints

### Investment Display Issues
- **Multiple Plans**: Fixed multiple active investment plans not showing on user dashboard
- **Investment History**: Fixed history only displaying one active investment instead of all
- **API Endpoints**: Updated to return all active investments instead of just one
- **Portfolio View**: Improved user experience by showing complete investment portfolio

## Improved

### Authentication Reliability
- **Script Detection**: Enhanced script loading detection with wait logic
- **Retry Mechanism**: Added automatic retry for reCAPTCHA loading failures
- **Debug Logging**: Added console logging for troubleshooting reCAPTCHA issues
- **Duplicate Prevention**: Prevented duplicate script loading with multiple auth forms

### Investment Management
- **Data Retrieval**: Changed from findOne to findAll for proper multiple investment handling
- **Response Handling**: Enhanced response handling for multiple investments
- **Error Handling**: Modified error handling to support investment arrays