# Core v5.3.3
**Release Date:** January 17, 2025  
**Tags:** INVESTMENT, ADMIN, UI/UX, DATATABLE, MULTISELECT, KYC, TRADING, ORDERBOOK, FINANCE, SPOT

## Fixed

### Investment System
- **Duration Selection**: Fixed investment plan creation/editing to properly support duration selection through multiselect dropdown
- **DataTable Modals**: Fixed cancel button causing page to become unresponsive
- **Duration Display**: Fixed multiselect component showing "undefined, undefined" for investment plan durations
- **Backend Support**: Fixed investment plan endpoints to handle both legacy and new duration formats

### KYC System
- **Application Submission**: Fixed KYC submission to redirect to correct application page using applicationId
- **Error Handling**: Improved error message display for KYC application submissions
- **JSON Parsing**: Enhanced KYC levels JSON parsing with proper error handling
- **Admin Search**: Fixed KYC admin application search filter for null/undefined values
- **Status Updates**: Fixed KYC application status updates with proper loading state management
- **Image Viewer**: Enhanced KYC admin image viewer with ESC key support and error handling

### Trading System
- **Orderbook Display**: Fixed orderbook to show multiple orders instead of single aggregated order per price level
- **Order Limits**: Increased orderbook default limit from 15 to 50 orders per side
- **Price Granularity**: Improved orderbook aggregation level from 0.1 to 0.01 for more granular pricing
- **WebSocket Handling**: Enhanced orderbook WebSocket handler to properly handle and limit data

### Finance System
- **Deposit Errors**: Fixed React error #31 "Objects are not valid as a React child" on deposit pages
- **JSON Parsing**: Improved deposit store JSON parsing with proper error handling and fallbacks
- **Method Rendering**: Enhanced deposit methods rendering with comprehensive object safety checks
- **SPOT Deposits**: Added missing transaction hash input field and monitoring step for SPOT deposits
- **Countdown Timer**: Fixed SPOT deposit countdown timer functionality

## Enhanced

### Investment Management
- **Duration Selection**: Enhanced investment plan admin interface with searchable duration multiselect
- **Form Validation**: Improved form validation and data processing for investment duration relationships
- **User Experience**: Better investment plan form with proper label formatting

### Admin Interface
- **DataTable Forms**: Enhanced DataTable cancel button with proper unsaved changes handling
- **KYC Management**: Improved KYC admin drawer state management with proper cleanup and initialization
- **Search Functions**: Enhanced KYC admin application search to include lastName in results

## Added

### Investment Features
- **Duration Management**: Added duration selection functionality to investment plan forms
- **API Integration**: Support for API-based multiselect options with proper label formatting
- **Data Transformation**: Proper data transformation for investment duration objects

### SPOT Deposit Features
- **Transaction Hash**: Added SPOT deposit transaction hash input field with validation
- **Monitoring Step**: Added SPOT deposit monitoring step showing transaction verification progress
- **Timer Functionality**: Added SPOT deposit countdown timer with proper initialization