# Core v5.2.8
**Release Date:** January 17, 2025  
**Tags:** FEATURE, BUG FIXES

## Fixed

### Page Loading & Navigation Issues
- **Builder Page**: Fixed crashes when loading legacy page content
- **Support Ticket Pages**: Fixed intermittent 502 errors and refresh issues
- **Ecosystem Token Pages**: Fixed hydration errors causing page failures
- **Dynamic Route Errors**: Fixed 502 errors in various admin sections

### Wallet & Blockchain Services
- **Master Wallet Creation**: Fixed "undefined" chain options in dropdown
- **Blockchain Services**: Fixed availability errors for Solana, TRON, and TON services
- **Chain Detection**: Improved chain status validation across development and production
- **Configuration Files**: Fixed blockchain services not finding their configuration files

### User Interface Issues
- **Currency Selection**: Fixed infinite loading loops for missing cryptocurrency logos
- **P2P Offer Tables**: Fixed sorting errors due to incorrect column references
- **Server-Side Rendering**: Fixed crashes caused by browser-only operations during SSR

### Technical Improvements  
- **WebSocket Stability**: Improved connection stability for real-time features
- **TypeScript Compilation**: Fixed backend compilation errors preventing server startup

## Enhanced

### Currency & Deposit System
- **Currency Selection**: Added search functionality and pagination for 100+ currencies
- **Deposit Interface**: Improved user experience with paginated currency lists (12 per page)
- **Search Filtering**: Added real-time search with result counts
- **Wallet Address API**: Enhanced backend to return proper address data

### Admin Interface
- **Hydration Stability**: Better error handling and race condition prevention
- **Master Wallet Forms**: Improved chain option loading and error handling
- **Error Messages**: Enhanced blockchain service availability messages

### Development & Production
- **Cross-Environment Support**: Better compatibility for blockchain service configuration
- **File Detection**: Robust detection logic for both development and production environments
- **Logging System**: Comprehensive logging for blockchain service debugging

## Added

### New Features
- **Search Functionality**: Real-time currency search in deposit forms
- **Pagination Controls**: Navigation for large currency lists
- **Fallback Images**: Placeholder images for missing cryptocurrency logos
- **Enhanced Translation**: Support for new UI elements and messages 