# Version 5.2.7

**Release Date:** January 17, 2025  
**Tags:** BUG FIXES, ADMIN IMPROVEMENTS, FOREX ENHANCEMENTS, EXCHANGE FIXES, ECOSYSTEM IMPROVEMENTS, PATH FIXES

## Fixed

### Admin Interface
- **Spot Currency Import**: Fixed import button not displaying after importing markets
- **Page Builder**: Fixed "something went wrong" error when editing home page
- **Support Chat**: Fixed error when accessing ticket conversations
- **Menu Extensions**: Fixed hover error "Cannot read properties of undefined"

### Trading Systems
- **Forex Accounts**: Fixed deposit and withdrawal buttons not working properly
- **Forex API**: Fixed double await syntax error causing runtime failures
- **Kucoin Exchange**: Fixed orderbook data fetching with invalid limit parameters
- **Currency Selection**: Fixed inconsistent type handling in Forex deposit store

### Ecosystem Features
- **Custodial Wallets**: Fixed creation failing due to smart contract path issues
- **Web Interface**: Fixed missing masterWalletId field in wallet creation
- **Smart Contracts**: Fixed file resolution with multiple path fallback options
- **Network Configuration**: Added fallback when environment variables are missing

### File System
- **Path Resolution**: Fixed critical issues causing frontend file access failures
- **Upload Endpoints**: Fixed incorrect paths going outside public_html
- **Media Directories**: Fixed paths not respecting development vs production differences
- **Documentation System**: Fixed swagger.json and docs-ui asset locations

## Added

### Admin Features
- **Import Currencies**: Added button to spot currency admin page
- **Agent Assignment**: Added missing support ticket assignment endpoint
- **Error Handling**: Comprehensive handling for ecosystem wallet creation
- **Smart Contract Fallback**: Multiple path options for wallet deployment

### System Improvements
- **Path Resolution**: Environment-aware resolution for all file operations
- **Debug Messages**: Enhanced debugging for custodial wallet creation
- **Validation**: Proper validation for wallet creation requests
- **Error Responses**: Specific failure reasons in API responses

## Improved

### Error Handling
- **Mega Menu**: Comprehensive null checking and try-catch protection
- **Error Messages**: More descriptive messages for wallet creation failures
- **Form Validation**: Better feedback for ecosystem wallet creation
- **Visual Feedback**: Improved during wallet deployment process

### System Reliability
- **File Uploads**: Proper handling for development vs production environments
- **Media Cache**: Correctly accesses frontend public directory
- **FAQ Scanner**: Properly locates Next.js app directory
- **Logo Upload**: Works properly regardless of deployment environment

### API Enhancements
- **Type Safety**: Improved in support ticket assignment
- **Error Boundaries**: Enhanced in admin menu components
- **Logging**: Comprehensive logging for debugging wallet issues
- **WebSocket**: Provider-specific validations for exchange markets