# Version 5.1.4
**Release Date:** June 24, 2025  
**Tags:** MOBILE IMPROVEMENTS, TRADING INTERFACE

## Fixed

### Mobile Order Book Issues
- **Scrolling Problems**: Fixed scrolling issue where orderbook items were cut off and couldn't be scrolled properly
- **Depth Bar Positioning**: Fixed asks depth bar positioning to match bids layout
- **Visual Improvements**: Added proper scrollbar styling and height constraints for better scrolling experience
- **Change Percentage Display**: Cleaned up orderbook ticker display by removing redundant change percentage

### Trading Header System
- **Infinite Loop**: Fixed issue where trading header would show loading state indefinitely
- **Mobile Ticker Display**: Fixed header ticker on mobile not updating when switching markets
- **Price Change Calculation**: Fixed incorrect price change display where absolute change was treated as percentage
- **Market Type Integration**: Enhanced market type handling for both mobile and desktop views

### Mobile Trade Interface
- **Market Selection**: Fixed issue where clicking on a market would sort by symbol instead of selecting the market
- **Binary Trading WebSocket**: Fixed issue where binary trading was duplicating trades during navigation
- **Subscription Management**: Enhanced WebSocket cleanup during navigation to prevent duplicate subscriptions

## Enhanced

### Mobile Order Book Experience
- **Auto-Scroll Feature**: Added automatic scrolling to show the best ask price by default on mobile
- **Redesigned Layout**: Improved mobile order book layout with asks above, ticker price in middle, and bids below
- **Enhanced Display**: Increased mobile orderbook display from 8 to 15 items to match desktop functionality
- **Touch Interactions**: Enhanced mobile touch interactions with larger touch targets and better spacing
- **Responsive Design**: Added responsive design that automatically detects mobile view and applies optimized layout

### Technical Improvements
- **WebSocket Cleanup**: Implemented proper cleanup of WebSocket subscriptions during page changes
- **State Management**: Enhanced market switching state management to prevent race conditions
- **Performance Optimization**: Fixed dependency arrays to prevent unnecessary re-renders and subscription loops 