# P2P v5.1.7
**Release Date:** August 27, 2025  
**Tags:** BUG FIXES, NEW FEATURES, ADMIN FEATURES, DATABASE MIGRATION

## Bug Fixes

### Payment Method Creation
#### Activity Logging Error
- **Fixed** "notNull Violation: p2pActivityLog.action cannot be null" error
- **Resolved** field name mismatches in p2pActivityLog usage across all P2P modules
- **Changed** `entityType`/`entityId` to correct `relatedEntity`/`relatedEntityId`
- **Added** required `action` field to all activity log entries
- **Fixed** metadata storage to use `details` field as JSON string

### Payment Methods Visibility
#### Access Control Issues
- **Fixed** users unable to see admin-created payment methods
- **Implemented** distinction between user-specific and globally available methods
- **Added** proper sorting to show global methods first
- **Resolved** visibility issues in user payment method selection

## New Features

### Global Payment Methods
#### Admin-Managed Methods
- **Added** `isGlobal` field to p2p_payment_methods table
- **Created** admin API endpoints for managing global payment methods
- **Implemented** global payment methods available to all users
- **Added** automatic marking of system methods as global
- **Enhanced** payment method fetch logic to include global methods

### Admin Payment Methods Management
#### Full CRUD Operations
- **View All Methods** - See global, system, and user-created methods in one interface
- **Create Global Methods** - Add payment methods accessible by all users
- **Edit Any Method** - Modify global, system, or user payment methods
- **Toggle Global Status** - Make any payment method globally available
- **Delete Methods** - Remove methods with safety checks for active usage
- **Sort & Filter** - Organize by type, status, creator, and creation date

## Technical Improvements

### Audit Logging
#### Enhanced Tracking
- **Fixed** field mapping in activity log entries
- **Improved** error handling in payment method operations
- **Enhanced** database relationships and type safety
- **Added** proper action tracking for all operations

### Admin Interface
#### DataTable Integration
- **Implemented** new Payment Methods section in P2P admin navigation
- **Added** DataTable with filtering, sorting, and pagination
- **Created** Create/Edit dialog with all payment method fields
- **Added** status indicators for method types (Global/System/User)
- **Implemented** creator tracking for user-created methods

### Backend Improvements
#### API Consistency
- **Updated** routes to use camelCase naming (paymentMethod)
- **Implemented** proper column definitions with editable fields
- **Added** standard permission patterns for CRUD operations
- **Enhanced** safety checks preventing deletion of methods in use

## Technical Details

### Files Modified

#### Backend
##### Core P2P Modules
- `backend/src/api/(ext)/p2p/payment-method/index.post.ts`
  - Fixed payment method creation logging
  - Set isGlobal=false for user-created methods

- `backend/src/api/(ext)/p2p/payment-method/index.get.ts`
  - Updated to include global methods for all users
  - Added proper sorting prioritizing global methods

- `backend/src/api/(ext)/p2p/utils/audit.ts`
  - Fixed audit log utility functions
  - Corrected field mappings

- `backend/src/api/(ext)/p2p/utils/p2p-trade-timeout.ts`
  - Fixed timeout handler logging
  - Added proper action fields

- `backend/src/api/(ext)/p2p/utils/ownership.ts`
  - Fixed admin action logging
  - Corrected entity relationships

##### Admin Endpoints
- `backend/src/api/(ext)/admin/p2p/paymentMethod/index.post.ts`
  - New admin create endpoint with getFiltered utility

- `backend/src/api/(ext)/admin/p2p/paymentMethod/index.get.ts`
  - Admin list endpoint with proper pagination

- `backend/src/api/(ext)/admin/p2p/paymentMethod/[id]/index.put.ts`
  - Admin update endpoint for all method types

- `backend/src/api/(ext)/admin/p2p/paymentMethod/[id]/index.del.ts`
  - Admin delete endpoint with safety checks

##### Database
- `backend/models/ext/p2p/p2pPaymentMethod.ts`
  - Added isGlobal field to model

- `backend/types/models/p2pPaymentMethod.d.ts`
  - Updated type definitions

- `backend/migrations/20240101000000-add-isGlobal-to-p2p-payment-methods.js`
  - Database migration for new column

#### Frontend
##### Admin Interface
- `frontend/app/[locale]/(ext)/admin/p2p/payment-method/page.tsx`
  - New admin payment methods page

- `frontend/app/[locale]/(ext)/admin/p2p/payment-method/client.tsx`
  - Admin client with DataTable integration

- `frontend/app/[locale]/(ext)/admin/p2p/payment-method/columns.tsx`
  - Table columns with editable fields

- `frontend/app/[locale]/(ext)/admin/p2p/payment-method/components/payment-method-dialog.tsx`
  - Create/edit dialog component

- `frontend/app/[locale]/(ext)/admin/p2p/components/navbar.tsx`
  - Added payment methods to admin navigation

##### Global Components
- `frontend/components/global/floating-chat-provider.tsx`
  - New global floating chat provider

## Database Migration

### Required Migration
**IMPORTANT**: Run the database migration to add the new `isGlobal` column:

```bash
npm run migrate
```

### Migration Details
The migration will:
- Add `isGlobal` column to `p2p_payment_methods` table
- Automatically mark existing system methods (userId = null) as global
- Ensure backward compatibility with existing payment methods

## Usage Instructions

### For Administrators
1. Navigate to **Admin → P2P → Payment Methods**
2. View all payment methods with their types and creators
3. Click "Add Payment Method" to create new global methods
4. Use edit button to modify existing methods
5. Toggle "Global" switch to control availability

### For Users
Users will automatically see:
- All global payment methods (admin-created)
- All system payment methods (built-in)
- Their own custom payment methods

No action required - improvements are automatic.

## Impact
- **Administrators** gain full control over payment methods
- **Users** have access to admin-created global payment methods
- **System** maintains proper audit trail for all operations
- **Database** properly tracks method ownership and visibility

## Breaking Changes
None - All changes are backward compatible with existing installations.

## Support
For issues or questions regarding these updates, please refer to the documentation or contact support.