# Version 5.0.9

**Release Date:** June 21, 2025  
**Tags:** CRITICAL FIXES, WEBSOCKET IMPROVEMENTS

## Fixed

### WebSocket Market Data
- **Message Validation**: Enhanced validation to prevent crashes from malformed data
- **Client Validation**: Fixed "Client undefined not found" errors
- **Symbol Validation**: Improved market loading and availability checks
- **Error Handling**: Better error messages for debugging
- **Subscription Cleanup**: Proper cleanup when clients disconnect
- **Market Validation**: Fixed market symbol errors with proper validation

### Real-time Chart Data
- **Live Updates**: Fixed charts stuck on single candle with hybrid real-time approach
- **Price Updates**: Real-time ticker updates for current candle
- **Periodic Refresh**: Fresh data fetching based on timeframe intervals
- **Smart Caching**: Improved candle cache management
- **Interval Optimization**: Appropriate fetch intervals for each timeframe
- **Memory Efficiency**: Better cleanup of caches and subscriptions

## Improved

### WebSocket Performance
- **Intelligent Polling**: Smart system that adapts to different timeframes
- **Debug Support**: Comprehensive logging for troubleshooting
- **Resource Management**: Optimized memory and connection handling